# -------
# mag.awk
# -------
BEGIN\
{
    printf("Calculating P = sqrt(X^2 + Y^2)\n");
    printf("Enter X: ");
    getline  x;
    printf("Enter Y: ");
    getline  y;

    x = (x < 0) ? -x : x;
    y = (y < 0) ? -y : y;

    printf("x = %e, y = %e\n", x, y);

    if (x < y)
    {
        t = x; x = y; y = t;
    }
    if (x == 0)
    {
        ans = 0;
    }
    else
    {
	if (1 <= x)
	{
	    xp = 2; x = x * 0.25; y = y * 0.25;
	}
	else
	{
	   xp = -2; x *= 4; y *= 4;
	}
	t = x - y;
	if (t == x)
	{
	    printf("Using Part 0.\n");
	    ans = x;
	}
	else if (y < t)
	{
	    printf("Using Part 1.\n");
	    q = x / y;
	    ans = x + y/(q + sqrt(q*q + 1));
	}
	else
	{
	    printf("Using Part 2.\n");
	    r2 = sqrt(2);		printf("r2 = %.14f\n", r2);
	    xh = 2.4142;
	    xl = r2 - 1.4142;		printf("xl = %.14f\n", xl);
	    q = t / y;
	    r = (q + 2) * q;
	    s = r / (r2 + sqrt(r + 2)) + xl + q + xh;

	    ans = x + y / s;
	}

	ans *= 2^xp;
    }

    printf("answer = %.16e\n", ans);
    printf("x = %e, y = %e, t = %e\n", x, y, t);
}
